// // // // // // // // // // // // //
//
//	Playground.cc
//
//	erstellt 27.12.97 von Andreas Warnke
//	geändert 17.5.98 von Andreas Warnke
//



// // // // // // // // // // // // //
//
//	include
//

#include <Window.h>
#include "ClientApplication.h"
#include "Playground.h"
#include "ConnectionStatus.h"
#include "Ebene.h"
#include "Definitions.h"
#include "AsciiKette.h"



// // // // // // // // // // // // //
//
//	Konstruktor
//

Playground :: Playground (
	BRect inRect,
	const char * inName,
	const char * inPassword,
	const char * inUniquePortName )
	: BWindow (
		inRect,
		inUniquePortName,
		B_DOCUMENT_WINDOW,
		B_WILL_DRAW)
{
	//	Size-Limits des Fensters:
	float minx, miny, maxx, maxy;
	GetSizeLimits( &minx, &maxx, &miny, &maxy );
	SetSizeLimits( 100, maxx, 100, maxy );
	UserWindowSize = inRect;
	
	//	Ebene:
	inRect.OffsetTo(0,0);
	inRect.right = inRect.right - B_V_SCROLL_BAR_WIDTH ;
	inRect.bottom = inRect.bottom - B_H_SCROLL_BAR_HEIGHT ;
	DieEbene = new Ebene ( inRect, inName, inPassword );
				
	//	Scrollview initialisieren:
	if ( DieEbene != NULL ) 
		DieScrollView = new BScrollView (
			"ScrollView",
			DieEbene,
			B_FOLLOW_ALL_SIDES,
			0,
			true,
			true,
			B_NO_BORDER
		);
	else
		DieScrollView = NULL; 
	if ( DieScrollView != NULL )
		AddChild ( DieScrollView );
	
	//	Der Ebene die ScrollView vorstellen:
	if ( DieEbene != NULL )
		DieEbene -> InitScroller ( DieScrollView );
		
	//	PulsRate:
	SetPulseRate (125000);
		
	//	Ermittle port_id
	DerLooperPort = find_port ( inUniquePortName );
	SetTitle ( inName );
		
	//	Fertig:
	Show ();
};



// // // // // // // // // // // // //
//
//	Destruktor
//

Playground :: ~Playground ()
{
	//	DieScrollView wird automatisch deleted.
	DieScrollView = NULL;
};



// // // // // // // // // // // // //
//
//	Quit - Button
//

bool Playground :: QuitRequested ()
{
	if ( be_app -> CountWindows () == 1 )
		//	dies ist das letzte Fenster.
		be_app -> PostMessage ( B_QUIT_REQUESTED );
	return true;
};



// // // // // // // // // // // // //
//
//	GetEbene
//

Ebene * Playground :: GetEbene ()
{
	return DieEbene;
};



// // // // // // // // // // // // //
//
//	MessageReceived:
//

void Playground :: MessageReceived ( BMessage * inMessage )
{
	switch ( inMessage -> what )
	{
	case Msg_Close:
		Quit ();
		break;
	case Msg_Zoom:
		inherited :: Zoom ();
		break;
	case Msg_Minimize:
		Minimize ( true );
		break;
	default:
		inherited :: MessageReceived ( inMessage );
	};
};



// // // // // // // // // // // // //
//
//	DispatchMessage:
//

void Playground :: DispatchMessage ( BMessage * inMessage, BHandler * inHandler )
{
	//	check for full port:
	CheckLooperPort ();
		
	//	daddy?
	inherited :: DispatchMessage ( inMessage, inHandler );
};



// // // // // // // // // // // // //
//
//	Zoom:
//

void Playground :: Zoom ( BPoint, float, float )
{
	BRect TheScreen = ClientApplication :: GetScreenRect ();
	BRect TheWindow = Frame ();
	if ( ( fabs ( TheWindow . left - TheScreen . left ) <= 5.0 )
		&& ( fabs ( TheWindow . right - TheScreen . right ) <= 5.0 )
		&& ( fabs ( TheWindow . top - TheScreen . top ) <= 5.0 )
		&& ( fabs ( TheWindow . bottom - TheScreen . bottom ) <= 5.0 ) )
	{
		//	Das Fenster nimmt den ganzen Bldschirm ein.
		inherited :: Zoom ( UserWindowSize . LeftTop (),
			UserWindowSize . Width (),
			UserWindowSize . Height () );
	}
	else
	{
		//	Das Fenster nimmt nicht den ganzen Bildschirm ein.
		UserWindowSize = TheWindow;
		inherited :: Zoom (	 TheScreen . LeftTop (),
			TheScreen . Width (),
			TheScreen . Height () );
	};
};



// // // // // // // // // // // // //
//
//	CheckLooperPort:
//

void Playground :: CheckLooperPort ()
{
	//	Check, if Message queue full:
	if ( port_count ( DerLooperPort ) > ( B_LOOPER_PORT_DEFAULT_CAPACITY / 3 ) )
	{
		//	Inform the user:
		char * sText = Concat (
			"The window ",
			Title (),
			" had to be closed because the system is too slow." );
		if ( sText != NULL )
		{
			BAlert * sAl = new BAlert (
				"Error",
				sText,
				"Hmm..." );
			if ( sAl != NULL )
				sAl -> Go ( NULL );
			delete [] sText;
		};
		Quit ();
	};
};



//
//	Ende
//
// // // // // // // // // // // // //